function [] = stk2tiff(stk)
%A function to save a matrix as a tiff stack.
%Synatax: stk2tiff(stk)
%Input: stk = a matrix of images.
%Output: Other than the file series, no outputs.

[x,y,z] = size(stk);    %get the size of the image stack.

%where do you want to save it?
[filename,pathname,filterindex] = uiputfile2('.tif');

%create the tag structure for the tiff image
tagstruct.ImageLength = y;
tagstruct.ImageWidth = x;
tagstruct.Photometric = 1;      %min is black
tagstruct.BitsPerSample = 16;   %16bit
tagstruct.SamplesPerPixel = 1;
tagstruct.RowsPerStrip = 2;
tagstruct.PlanarConfiguration = Tiff.PlanarConfiguration.Chunky;
tagstruct.Software = 'MATLAB';
tagstruct.ImageDescription = 'Matlab, Gordon, Deconvoluted';

%now save stack as a series of images
warning('OFF')
h2 = waitbar(0,['Saving Image: ',num2str(1),' to ',pathname,filename,'.tif']);    %initialize progress bar.
for i = 1:z
    h = Tiff([pathname,filename,num2str(i),'.tif'],'w');    %open tiff object
    h.setTag(tagstruct);            %set the tag structure
    h.write(uint16(stk(:,:,i))'); %write the image & rotate it to video coordinates
    close(h);                       %close the file
    waitbar(i/z,h2,['Saving Image: ',num2str(i+1),' to ',pathname,filename,'.tif']);   %update progress
end
close(h2)
warning('ON')